//
//  OPFolder.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-02-19.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import "OPDatabaseObjectWithOverview.h"

#define SMART_FOLDER_VERSION_4 4

@interface OPFolder : OPDatabaseObjectWithOverview <OPDisplayOrderable, OPSyncable, NSSecureCoding>

@property (nonatomic) OPTimestamp createdAt;
@property (nonatomic) OPTimestamp updatedAt;
@property (strong, nonatomic) NSString * uuid;
@property (nonatomic) OPID parentId;
@property (nonatomic, copy) NSString * parentUUID;
@property (nonatomic, getter=isSmartFolder) BOOL smartFolder;
@property (nonatomic) NSUInteger displayOrder;
@property (nonatomic, strong) NSData * iconData;

@property (nonatomic, strong) NSPredicate * smartFolderPredicate;
@property (nonatomic, assign) NSUInteger smartFolderVersion;

@property (nonatomic) NSString * title;
@property (readonly) NSString * lowercaseTitle;
@property (nonatomic) OPImage * icon;


@property (nonatomic) NSUInteger numberOfChildren;
@property (nonatomic) NSUInteger numberOfItems;

// helper properties
@property (nonatomic, readonly) NSUInteger indentationLevel;
@property (nonatomic, readonly) NSArray * subfolders;

@property (nonatomic, weak) OPFolder *parentFolder;

- (void)addSubfolder:(OPFolder *)subfolder;
- (BOOL)isParentOfFolder:(OPFolder *)folder;

- (NSArray *)flattenedAndSorted;
- (NSString *)localizedSubtitle;


@end

